clc
clear
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default

%% Input data
%Physical parameters
Rg=287.053; %Costante dell'aria (J/kg/K)
mu=1.81e-5; %viscosita` dinamica dell'aria a 20C (Pa s)
pa=101325;
Temp=293;                  %Temperature (K)
rho=pa/(Rg*Temp);
dt=4e-9;                %Time Step (s)
cG=60000/rho;
%Geometrical parameters
R1 =16e-3 ; % inner radius (m)
R2 =33e-3 ;  % outer radius (m)
Rb = R2*0.64; % Optimized base radius (m)

% r_i = 16*1e-3;
% r_e = 33*1e-3;
% r_m = (r_i+r_e)/2;
T1d=0; %deg
T1=T1d*pi/180;
no_grooves=12;
passo = 2*pi*R2/no_grooves;
% T2 = 2*pi/no_grooves;     %= 2*pi/K [rad] periodicity angle
T2 = 2*pi;
Omega_rpm=[5 10:10:70]*1e3;
% Omega_rpm=(10:20:200)*1e3;
% Omega_rpm = omega;
Omega=Omega_rpm*2*pi/60;
h_vec = (10:2:20)*1e-6;
h_min = h_vec(1);
h_mean = 20e-6;

%Definizione numero elementini nelle due direzioni
M=30; %direzione radiale
N=360*2;%direzione circonferenziale
deltar=(R2-R1)/(M-1);
deltat=(T2-T1)/(N-1);
nR =linspace(R1,R2,M)'; %Vettore dei raggi
nT =linspace(T1,T2,N)';%Vettore degli angoli

[Theta,R] = meshgrid(nT,nR) ; %crea le coordinate di tutti i punti %nR lo replica su ogni riga %nT su ogni colonna
Theta = Theta';R = R';

%% Geometry definition
beta = 70; 
% beta = deg2rad(beta);
% delta_beta = deg2rad(-8);
delta_beta = 0;
a1 = 11e-3 ;
a2 = 5.5e-3;              %a1=X*a2
% Rb = 20e-3;
% X_spiral = a1/a2;
X_spiral = 0.64;
Y_spiral = (R2-Rb)/(R2-R1);
% b = 3.5e-3 ;            %b=Y*(b+c)
% Rb = R2-b;
c = Rb-R1;
% alfaSpiral = deg2rad(60);       % base angle of spiral [rad] (optm Muijdermann)

%Indentify grooved regions
% angle = -tan(alfaSpiral)*log(R/R2);         % foundametal log spiral leading edge
[ang,ang1,isGroove] = GetGrooves(R1*1e3,R2*1e3,X_spiral,Y_spiral,no_grooves,beta,delta_beta,R*1e3,Theta);

Z = zeros(size(R));
Z(isGroove) = h_vec(1)+h_mean;
Z(~isGroove) = h_vec(1);
% X = R.*cos(Theta);
% Y = R.*sin(Theta);
% 
% figure
% mesh(X*1e3,Y*1e3,Z*1e6)
% xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')


pad_section = 30; % [deg]
n_points = round(pad_section/360*N);
N = n_points;
H0 = Z(1:n_points,:);
H0 = [Z(end,:);H0;Z(n_points+1,:)]';
isGroove = H0==h_vec(1)+h_mean;
R = [R(end,:);R(1:n_points+1,:)]';
T = [Theta(end,:);Theta(1:n_points+1,:)]';
% H0_aux_groove = -groove_func(R);
% H0(isGroove) = H0_aux_groove(isGroove)+h2;
H0(isGroove) = h_mean + h_min;
% H0_aux_flat = abs(flat_func(R));
% H0(~isGroove) = H0_aux_flat(~isGroove)+h2;
H0(~isGroove) = h_min;
H0(end,end) = h_min;
X = R.*cos(T);
Y = R.*sin(T);
% Rv=sqrt(X.^2+Y.^2);
Rv = R;

figure
mesh(X*1e3,Y*1e3,H0*1e6)
xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Air Gap Height ($\mu m$)')
% colorbar
% view(2)
% axis equal
pause(0.1)


%% Variable Initialization
%COndizioni Periodicit
% pold=ones(N+2,M)*pa; %N+2 per periodicit circolare lungo theta
% pnew=ones(N+2,M)*pa;
%COndizioni di Dirichelet p=Pa sul bordo esterno

Ft=[];
Gint=[];
Goutt=[];
Err_G=[];

Err_P=[];
Err_F=[];
no_punti=100;
no_pad=12;
F_mat = zeros(length(h_vec),length(Omega));
legend_cell = cell(1,length(h_vec));
W = zeros(size(Omega));
Qin = W;
Qout = W;

for h_i = 1:length(h_vec)
Pold=ones(M,N+2)*pa; %MODIFICATO
Pnew=Pold;

% H0(isGroove) = h_vec(omega_ind)+H0_aux_groove(isGroove);
H0(isGroove) = h_vec(h_i)+h_mean;
% H0(~isGroove) = h_vec(omega_ind)+H0_aux_flat(~isGroove);
H0(~isGroove) = h_vec(h_i);
fprintf('h = %d um\n',h_vec(h_i)*1e6)


for omega_ind=1:length(Omega)
    omega=Omega(omega_ind);


    tic
    err_P=10;
    err_F=10;
    err_G=10;

    %portate uscita nodo
    GN=zeros(M,N); %N and M are for BC
    GS=zeros(M,N);
    gO=zeros(M,N);
    gE=zeros(M,N);
    F0=0;
    F1=0;

    iter=0;
    contatore=0;
    toll=1e-6;
    while abs(err_P)>toll || abs(err_G)>toll || abs(err_F)>toll
        iter=iter+1;
        contatore=contatore+1;
        F0=F1;
        Pold=Pnew;


        ii=2:M-1;   jj=2:N-1; %Nodi interni
        %Calcolo portata uscita radiale
        GN(ii,jj)=-(Pold(ii-1,jj).*H0(ii-1,jj).^3.*Rv(ii-1,jj)+Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii,jj)-Pold(ii-1,jj));
        GS(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3.*Rv(ii,jj)+Pold(ii+1,jj).*H0(ii+1,jj).^3.*Rv(ii+1,jj))./(24*mu*Rg*Temp*deltar).*(Pold(ii+1,jj)-Pold(ii,jj));
        %Calcolo portata uscita circonferenziale
        gOp(ii,jj)=-(Pold(ii,jj-1).*H0(ii,jj-1).^3+Pold(ii,jj).*H0(ii,jj).^3)./(12*mu*Rg*Temp*(Rv(ii,jj-1)+Rv(ii,jj)).*deltat).*(Pold(ii,jj)-Pold(ii,jj-1));
        gOc(ii,jj)=omega*(Pold(ii,jj-1).*H0(ii,jj-1).*Rv(ii,jj-1)+Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj))./(4*Rg*Temp);
        gO(ii,jj)=gOp(ii,jj)+gOc(ii,jj);
        gEp(ii,jj)=-(Pold(ii,jj).*H0(ii,jj).^3+Pold(ii,jj+1).*H0(ii,jj+1).^3)./(12*mu*Rg*Temp*(Rv(ii,jj)+Rv(ii,jj+1)).*deltat).*(Pold(ii,jj+1)-Pold(ii,jj));
        gEc(ii,jj)=omega*(Pold(ii,jj).*H0(ii,jj).*Rv(ii,jj)+Pold(ii,jj+1).*H0(ii,jj+1).*Rv(ii,jj+1))./(4*Rg*Temp);
        gE(ii,jj)=gEp(ii,jj)+gEc(ii,jj);
        %Calcolo pressione meato da equazione di continuit
        Pnew(ii,jj)=Pold(ii,jj)+((GN(ii,jj)-GS(ii,jj))*deltat+(gO(ii,jj)-gE(ii,jj))*deltar).*(dt*Rg*Temp)./(H0(ii,jj).*Rv(ii,jj)*deltar*deltat);

        %Calcolo errore Pressione
        err_P=abs(max((Pnew(:)-Pold(:))./Pold(:)));
        % Err_P_i(iter)=err_P;

        %Diverge?
        if any(isnan(Pnew(:))) || any(isinf(Pnew(:)))
            fprintf('Iterations diverge\n');
            return;
        end
        %Calcolo della capacit di carico
        F1=sum((Pnew-pa)*deltar*deltat.*Rv,'all');

        %Calcolo della portata in uscita O-N-E-S
        Gin=sum(GN(ii,jj)*deltat+gO(ii,jj)*deltar,'all');
        Gout=sum(GS(ii,jj)*deltat+gE(ii,jj)*deltar,'all');
        % %Calcolo errore
        err_F=(F1-F0)/F1;
        err_G_num=sum(Gin-Gout,'all');
        err_G=err_G_num/Gout;

        % if contatore==no_punti
        %     Ft=[Ft F1*no_pad];
        %     Gint=[Gint Gin];
        %     Goutt=[Goutt Gout];
        %     Err_P=[Err_P err_P];
        %     Err_G=[Err_G err_G];
        %
        %     Err_F=[Err_F err_F];
        %     contatore=0;
        % end

    end
    toc
    W(omega_ind)=F1*no_grooves;
    Qin(omega_ind)=Gin*cG;
    Qout(omega_ind)=Gout*cG;

    figure
    surf(X*1e3,Y*1e3,Pnew), hold on
    xlabel('X (mm)'),ylabel('Y (mm)'),zlabel('Pressure (Pa)')
    grid on
    % set(gca,'FontSize', 24)
    pause(0.5)
end
F_mat(h_i,:) = W;

end

%% Curve Caratteristiche
% Capacit di carico
% figure
% plot(h_vec*1e6,W,'b'),hold on
% plot(h_vec*1e6,W,'ro'),hold on
% xlabel('Air gap $h$ [$\mu m$]'),ylabel('Load Capacity $W$ (N)')
% title('Spiral Bearing load capacity at minium rotational speed $\omega_{min}$')
% % legend('Numerical','Experimental')
% grid on

% Portata Ingresso-Uscita
% figure
% plot(h_vec*1e6,Qin,'b'),hold on
% plot(h_vec*1e6,Qout,'ro'),hold on
% xlabel('Angular Speed $\omega$ (krpm)'),ylabel('Air Flow $Q$ (l/min)'),

figure 
hold on
for i = 1:length(h_vec)
plot(Omega_rpm*1e-3,F_mat(i,:))
legend_cell{i} = [num2str(h_vec(i)*1e6) ' $\mu m$ air gap'];
end
% plot(Omega_rpm*1e-3,ones(size(W))*Load,'k', 'DisplayName', 'Experimental')
% plot(Omega_rpm*1e-3,W,'ro') 
hold off
% plot(Omega_rpm(1:length(W))*1e-3,Load,'k')
legend(legend_cell,'Interpreter','latex','Location','northwest')
xlabel('Angular Speed $\omega$ (krpm)')
ylabel('Load Capacity $W$ (N)')
title('Spiral grooved bearing Theoretical load capacity')
% legend('Numerical','Experimental','Location','best')
% legend([h1,h2],'Location','best')
% legend show
axis padded
figureEditor
grid on


%% Salvataggio
F_mat_opt = F_mat;
h_vec_spiral = h_vec;
save Spiral_static_opt F_mat_opt h_vec_spiral Omega_rpm

fid = fopen('sim_data_spiral.txt','wt');
fprintf(fid,'dt: %+.2e\n',dt);
fprintf(fid,'M: %d\nN: %d\n',M,N);
fclose(fid);

% load Spiral_static.mat
% figure
% plot(h_vec_spiral,W_spiral)

   